;;;   DDPTYPE.LSP
;;;   Copyright (C) 1992 by Autodesk, Inc.
;;;      
;;;   Permission to use, copy, modify, and distribute this software 
;;;   for any purpose and without fee is hereby granted, provided 
;;;   that the above copyright notice appears in all copies and that 
;;;   both that copyright notice and this permission notice appear in 
;;;   all supporting documentation.
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;;;   WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;;;   PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;
;;;   C:DDPTYPE - set point style and size dialogue for use with
;;;               the AutoCAD Release 12 Standard Menu.
;;;
;;;               Uses ddptype.dcl for the dialogue definition.  The
;;;               slide images are in acad.slb.
;;;
;;; ===========================================================================
;;; ===================== load-time error checking ============================
;;;

  (defun ai_abort (app msg)
     (defun *error* (s)
        (if old_error (setq *error* old_error))
        (princ)
     )
     (if msg
       (alert (strcat " Application error: "
                      app
                      " \n\n  "
                      msg
                      "  \n"
              )
       )
     )
     (exit)
  )

;;; Check to see if AI_UTILS is loaded, If not, try to find it,
;;; and then try to load it.
;;;
;;; If it can't be found or it can't be loaded, then abort the
;;; loading of this file immediately, preserving the (autoload)
;;; stub function.

  (cond
     (  (and ai_dcl (listp ai_dcl)))          ; it's already loaded.

     (  (not (findfile "ai_utils.lsp"))                     ; find it
        (ai_abort "DDPTYPE"
                  (strcat "Can't locate file AI_UTILS.LSP."
                          "\n Check support directory.")))

     (  (eq "failed" (load "ai_utils" "failed"))            ; load it
        (ai_abort "DDPTYPE" "Can't load file AI_UTILS.LSP"))
  )

  (if (not (ai_acadapp))               ; defined in AI_UTILS.LSP
      (ai_abort "DDPTYPE" nil)         ; a Nil <msg> supresses
  )                                    ; ai_abort's alert box dialog.

;;; ==================== end load-time operations ===========================

(defun ai_ptype_start ( / pt1 pt2)
  (setq ai_pts_lst '("0" "1" "2" "3" "4" "32" "33" "34" "35" "36"
                     "64" "65" "66" "67" "68" "96" "97" "98" "99" "100")
  )
  (foreach pt0 ai_pts_lst
    (setq pt1 (strcat "pdmode" pt0)
          pt2 (getvar "PDMODE")
    )
    (start_image pt1)
    (slide_image 
      0 0
      (- (dimx_tile pt1) 1) (- (dimy_tile pt1) 1) 
      (strcat "acad(pt" pt0 ")")
    )
    (if (= pt2 (atoi pt0))
      (mode_tile pt1 2)
    )
    (end_image)
  )
)

(defun ai_ptype_set ()
  (ai_chk_pts nil)
  (if ai_pts_do
    (progn
      (if ai_pts0
        (setq ai_pts 0.0)
        (if (= (get_tile "pdsize_r") "1")
          (setq ai_pts (- 0.0 ai_pts))
        )
      )
      (setvar "PDSIZE" ai_pts)
      (setvar "PDMODE" (atoi (substr ai_ptmode 7 3)))
      (done_dialog 1)
    )
  )
)

(defun ai_chk_pts (pts0)
  (cond ((or (= ai_pts nil)
             (<= ai_pts 0.0)
         )
         (set_tile "error" "Invalid input.")
         (setq ai_pts_do nil)
         (mode_tile "pdsize_value" 2)
        )
        (T
         (set_tile "error" "")
         (setq ai_pts_do T)
         (if pts0
           (setq ai_pts0 nil)
         )
        )
  )
)

(defun ai_pdsize_r ()
  (setq ai_pt_do T ai_pts0 nil)
  (set_tile "pdsize_label" "%")
)

(defun ai_pdsize_a ()
  (setq ai_pt_do T ai_pts0 nil)
  (set_tile "pdsize_label" "Units")
)

(defun do_help (cmd)
  (if (= (type acad_helpdlg) 'EXSUBR)
    (acad_helpdlg "acad.hlp" cmd)
    (alert "Help dialogue not found - xload acadapp.")
  )
  (princ)
)

(defun ai_ptype_main (/ globals)
  (ai_ptype_start)
  (mode_tile ai_ptmode 4)
  (if (<= ai_pts 0.0)
    (progn
      (set_tile "pdsize_r" "1")
      (set_tile "pdsize_label" "%")
    )
    (progn
      (set_tile "pdsize_a" "1")
      (set_tile "pdsize_label" "Units")
    )
  )
  (set_tile "pdsize_value" (rtos (setq ai_pts (abs ai_pts))))
  (foreach pd0 ai_pts_lst
    (action_tile (strcat "pdmode" pd0) 
      "(mode_tile ai_ptmode 4)(setq ai_ptmode $key)(mode_tile ai_ptmode 4)"
    )
  )
  (action_tile "pdsize_value" "(setq ai_pts (distof $value)) (ai_chk_pts T)")
  (action_tile "pdsize_r" "(ai_pdsize_r)")
  (action_tile "pdsize_a" "(ai_pdsize_a)")
  (action_tile "accept" "(ai_ptype_set)")
  (action_tile "help" "(do_help \"ddptype\")")
  (start_dialog)
)

(defun c:ddptype (/ app dcl_id old_cmd ai_pts_do ai_ptmode ai_pts 
                    ai_pts0 undo_init)

  ;; Set up error function.
  (setq old_cmd (getvar "cmdecho")    ; save current setting of cmdecho
        old_error  *error*            ; save current error function
        *error* ai_error              ; new error function
  )

  (setvar "cmdecho" 0)

  (cond
     (  (not (ai_trans)))                        ; transparent OK
     (  (not (ai_acadapp)))                      ; ACADAPP.EXP xloaded?
     (  (not (setq dcl_id (ai_dcl "ddptype"))))  ; is .DCL file loaded?
     (T 
        (if (/= 1 (logand (getvar "CMDACTIVE"))) (ai_undo_push))
        (ddptype_main)        
        (if (/= 1 (logand (getvar "CMDACTIVE"))) (ai_undo_pop))
     )                          ; proceed!
  )

  (setq *error* old_error) 
  (setvar "cmdecho" old_cmd)
  (princ)
)

(defun ddptype_main()
  (if (not (new_dialog "ddptype" dcl_id))
    (exit)
  )
  
  (setq ai_ptmode (strcat "pdmode" (itoa (getvar "PDMODE"))) 
        ai_pts (getvar "PDSIZE")
  )
  (setvar "CMDECHO" 0)
  (if (= ai_pts 0.0)
    (setq ai_pts -5.0 ai_pts0 T)
  )
  (ai_ptype_main)

  (princ)
)

(princ "  DDPTYPE loaded.")
(princ)
